<%@ Language="PerlScript" EnableSessionState="false" %>
<%
#!/usr/bin/perl

# La Kameleono - Versio 5.0 (26 Marto 2001)
# Verkita de Bertilo Wennergren
# Tio chi estas Perlskripta ASP-versio de la Kameleono.
# Ekzistas ankau ASP-versio en VBSkripto kaj krome CGI-versio en Perlo.

# DIFINU CHI TIE LA BAZAJN ELEKTOJN POR LA KAMELEONO
my $adreso = "http://www.servilo.eo/~nomo/";
my $loko_de_paghoj = "";
my $baza_sistemo = "unik";
my $baza_pagho = "index.html";
my $chiam_trakti = "ne";
my $purismo = "ne";
my $ssi = "ne";
#	FINO DE LA BAZAJ ELEKTOJ POR LA KAMELEONO

# NOMOJ DE LA SISTEMOJ
my %sistemoj =
(	unik  => qq (Esperantaj literoj: <tt>Unikodo</tt>&nbsp;),
	lat3a => qq (Esperantaj literoj: <tt>Latino 3</tt>&nbsp;),
	lat3b => qq (Esperantaj literoj: <tt>Latino 3 sen signokoda indiko</tt>&nbsp;),
	ghu   => qq (Esperantaj literoj: <tt>ch, gh... u</tt>&nbsp;),
	x     => qq (Esperantaj literoj: <tt>cx, gx... ux</tt>&nbsp;),
	cgcu  => qq (Esperantaj literoj: <tt>^c, ^g... ^u</tt>&nbsp;),
	gcuc  => qq (Esperantaj literoj: <tt>c^, g^,... u^</tt>&nbsp;),
	cgtu  => qq (Esperantaj literoj: <tt>^c, ^g... ~u</tt>&nbsp;),
	gcut  => qq (Esperantaj literoj: <tt>c^, g^... u~</tt>&nbsp;),
	ghw   => qq (Esperantaj literoj: <tt>ch, gh... w</tt>&nbsp;),
	vx    => qq (Esperantaj literoj: <tt>cx, gx... vx</tt>&nbsp;),
	grur  => qq (Esperantaj literoj: <tt>c`, u`... u`</tt>&nbsp;)
);

# VARIABLOJ POSTE UZOTAJ
my (%m, @mezo, @protekto, @de, @al);
my ($uzanto, $loko, $pagho, $fasono, $prog, $cgi, $tradukescepto);
my ($bazo, $mendita_teksto, $chapo, $signokodo_origina, $signokodo_nova, $stilfolio, $netscape_4);
my $ag = $Request->ServerVariables('HTTP_USER_AGENT')->{Item};
my $path = $Request->ServerVariables('PATH_TRANSLATED')->{Item};
my $query = $Request->ServerVariables('QUERY_STRING')->{Item};
my $serv = $Request->ServerVariables('SERVER_NAME')->{Item};
my $script = $Request->ServerVariables('SCRIPT_NAME')->{Item};

&difini_sistemojn;

# TRANSFORMAS LA HTTP-ADRESON EN LOKAN ADRESON
$adreso .= "/" unless $adreso =~ m!/$!;
($uzanto) = $adreso =~ m!http://[^/]+(/.*?)$!;

# KAPTAS LA MENDON
for ($query)
{	s!([\xc0-\xc3])([\x80-\xbf])!chr((ord($1)-0xC0)*2**6+(ord($2)-0x80))!eg;
	s!%([\dA-Fa-f]{2})!chr(hex($1))!eg;
}
if ($query =~ m![&;=]!)
{	%m = split(/[&;=]/,$query);
}
else
{	%m = ($query,1);
	$m{d} = $query;
}

# TROVAS LA DOSIERUJON KAJ LA PAGHON DE LA MENDO
$m{d} =~ s|\s||g;
($loko,$pagho) = $m{d} =~ m!^(.*?/)?([^/]*?\.[Ss]?[Hh][Tt][Mm][Ll]?)?$!g;
$loko =~ s|\\||g;
$pagho = $baza_pagho if $pagho eq "";
$loko = "", $pagho = $baza_pagho if $loko =~ m|\.\./|;

# DIFINAS LA NOMON KAJ LOKON DE LA CGI-PROGRAMETO
($prog = "http://$serv$script") =~ s|^(.*?)([^\\\/]+)$|$2|;
$cgi = $1;

# SENDAS SIMPLAN ELEKTILON
&simpla_elektilo if defined $m{s};

# TROVAS LA NOMON DE LA LEGILO
&kiu_legilo;

# POSTAJ MENDOKODOJ ENMETOTAJ EN LA LIGOJN DE LA PAGHO
$m{m} = "x" if $m{m} eq "gxux";
if ($m{m} eq "")
{	$fasono = "d=$loko";
}
else
{	$fasono = "m=$m{m};d=$loko";
}

# LEGAS LA MENDITAN PAGHON
($mendita_teksto = $loko_de_paghoj.$loko.$pagho) =~ s|(#.*)$||;
$_ = &legi($mendita_teksto,1);

&redirekti;

if ($ssi eq "jes")
{	while (m!(<\!--\s*#(include)\s+([^>]+)\s*-->)!) { &ssi($1,$2,$3) }
}

# FORIGAS XML-INDIKON SE "Opera" AU malnova "Mozilla" au "Macintosh MSIE 4" LEGAS
if ( $ag =~ m|Mozilla/[23]| || $ag =~ m!Opera[/ ][0-3]! || ( $ag =~ m|Mozilla/4| ) && ($ag =~ m|Macintosh| ) )
{	s!(<\?xml\s+[^>]*\?>\s*)!!;
}

$tradukescepto = 1 if (m|<\!-- NETRADUKENDA PAGHO|) || ($m{m} eq "");

&nova_chapo unless m|<\!-- NETRADUKENDA PAGHO|;

&escepti_tekstopartojn;

&elekti_sistemojn unless $tradukescepto;

&aktuala_sistemo;

&adapti_adresojn;

unless ($tradukescepto)
{	&traduki_al_unikodo unless $de[0] eq "&#265;";
	&traduki_okbitajn_signojn;
	&traduki_al_celsistemo unless $al[0] eq "&#265;";
}

&adapti_elektilojn;
&remeti_protektitajn_tekstopartojn;

# LIVERAS LA PRETAN PAGHON
$Response->{ContentType} = 'text/html'.$chapo;
$Response->Write($_);

##############
# SUBRUTINOJ #

# DIFINAS LA SISTEMOJN
sub difini_sistemojn
{	@unik = (
		"&#265;", "&#285;", "&#293;", "&#309;", "&#349;", "&#365;", 
		"&#264;", "&#284;", "&#292;", "&#308;", "&#348;", "&#364;", 
		"&#264;", "&#284;", "&#292;", "&#308;", "&#348;", "&#364;", 
		"&#365;", "&#364;", "&#364;");

	@mezo = @unik;

	@utf8 = (
		"\xc4\x89", "\xc4\x9d", "\xc4\xa5", "\xc4\xb5", "\xc5\x9d", "\xc5\xad", 
		"\xc4\x88", "\xc4\x9c", "\xc4\xa4", "\xc4\xb4", "\xc5\x9c", "\xc5\xac", 
		"\xc4\x88", "\xc4\x9c", "\xc4\xa4", "\xc4\xb4", "\xc5\x9c", "\xc5\xac", 
		"\xc5\xad", "\xc5\xac", "\xc5\xac");

	@lat3 = (
		"\xe6", "\xf8", "\xb6", "\xbc", "\xfe", "\xfd", 
		"\xc6", "\xd8", "\xa6", "\xac", "\xde", "\xdd", 
		"\xc6", "\xd8", "\xa6", "\xac", "\xde", "\xdd", 
		"\xfd", "\xdd", "\xdd");

	@ghu = (
		"c&#104;", "g&#104;", "h&#104;", "j&#104;", "s&#104;", "&#117;", 
		"C&#72;", "G&#72;", "H&#72;", "J&#72;", "S&#72;", "&#85;", 
		"C&#104;", "G&#104;", "H&#104;", "J&#104;", "S&#104;", "&#85;", 
		"&#119;", "&#87;", "&#87;");

	@x = (
		"cx", "gx", "hx", "jx", "sx", "ux", 
		"CX", "GX", "HX", "JX", "SX", "UX", 
		"Cx", "Gx", "Hx", "Jx", "Sx", "Ux", 
		"vx", "VX", "Vx");

	@cgcu = (
		"^c", "^g", "^h", "^j", "^s", "^u", 
		"^C", "^G", "^H", "^J", "^S", "^U", 
		"^C", "^G", "^H", "^J", "^S", "^U", 
		"~u", "~U", "~U");

	@gcuc = (
		"c^", "g^", "h^", "j^", "s^", "u^", 
		"C^", "G^", "H^", "J^", "S^", "U^", 
		"C^", "G^", "H^", "J^", "S^", "U^", 
		"u~", "U~", "U~");

	@cgtu = (
		"^c", "^g", "^h", "^j", "^s", "~u", 
		"^C", "^G", "^H", "^J", "^S", "~U", 
		"^C", "^G", "^H", "^J", "^S", "~U", 
		"^u", "^U", "^U");

	@gcut = (
		"c^", "g^", "h^", "j^", "s^", "u~", 
		"C^", "G^", "H^", "J^", "S^", "U~", 
		"C^", "G^", "H^", "J^", "S^", "U~", 
		"u^", "U^", "U^");

	@ghw = (
		"c&#104;", "g&#104;", "h&#104;", "j&#104;", "s&#104;", "&#119;", 
		"C&#72;", "G&#72;", "H&#72;", "J&#72;", "S&#72;", "&#87;", 
		"C&#104;", "G&#104;", "H&#104;", "J&#104;", "S&#104;", "&#87;", 
		"&#117;", "&#85;", "&#85;");

	@vx = (
		"cx", "gx", "hx", "jx", "sx", "vx", 
		"CX", "GX", "HX", "JX", "SX", "VX", 
		"Cx", "Gx", "Hx", "Jx", "Sx", "Vx", 
		"ux", "UX", "Ux");

	@grur = (
		"c`", "g`", "h`", "j`", "s`", "u`", 
		"C`", "G`", "H`", "J`", "S`", "U`", 
		"C`", "G`", "H`", "J`", "S`", "U`", 
		"u`", "U`", "U`");
}


# SENDAS SIMPLAN ELEKTILON
sub simpla_elektilo
{	my ($koloro1, $koloro2, $koloro3);
	my @koloroj =
		qw(#ffffff #ffff00 #f0e68c #00ff7f #faebd7 #ff0000 #808000 #cd5c5c #d3d3d3 #ffcc99);

	if ($m{s} =~ m!^(\d)(\d)(\d)?$!)
	{
		$koloro1 = qq($koloroj[$1]);
		$koloro2 = qq($koloroj[$2]);
	}
	else
	{
		$koloro1 = qq($koloroj[8]);
		$koloro2 = qq($koloroj[9]);
	}
	if ($m{s} =~ m!^\d\d(\d)$!)
	{
		$koloro3 = qq($koloroj[$1]);
	}
	else
	{
		$koloro3 = "#000000";
	}
	$Response->{ContentType} = 'text/html;charset=UTF-8';
%><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
  "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>Elekti sistemon</title>
<style type="text/css">
<!--
body { background-color: <%=$koloro1%>; }
h2 { color: <%=$koloro3%>; background-color: <%=$koloro1%>; }
table { background-color: <%=$koloro2%>; color: #000; }
-->
</style>
</head>
<body>

<h2>Elektu sistemon:</h2>

<table summary="Elektilo de sistemoj por la Esperantaj literoj" cellpadding="3%" border="2" frame="border" rules="all">
<tr><td><a href="<%=$cgi.$prog%>?m=unik;d=<%=$m{d}%>"><b>Unikodo: &#265;, &#285;... &#365;</b></a></td></tr>
<tr><td><a href="<%=$cgi.$prog%>?m=lat3a;d=<%=$m{d}%>"><b>Latino 3</b></a></td></tr>
<tr><td><a href="<%=$cgi.$prog%>?m=lat3b;d=<%=$m{d}%>"><b>Latino 3 sen signokoda indiko</b></a></td></tr>
<tr><td><a href="<%=$cgi.$prog%>?m=ghu;d=<%=$m{d}%>"><b>H-sistemo: ch, gh... u</b></a></td></tr>
<%
	unless ($purismo eq "jes")
	{
%><tr><td><a href="<%=$cgi.$prog%>?m=x;d=<%=$m{d}%>"><b>cx, gx... ux</b></a></td></tr>
<tr><td><a href="<%=$cgi.$prog%>?m=cgcu;d=<%=$m{d}%>"><b>^c, ^g... ^u</b></a></td></tr>
<tr><td><a href="<%=$cgi.$prog%>?m=gcuc;d=<%=$m{d}%>"><b>c^, g^... u^</b></a></td></tr>
<tr><td><a href="<%=$cgi.$prog%>?m=cgtu;d=<%=$m{d}%>"><b>^c, ^g... ~u</b></a></td></tr>
<tr><td><a href="<%=$cgi.$prog%>?m=gcut;d=<%=$m{d}%>"><b>c^, g^... u~</b></a></td></tr>
<tr><td><a href="<%=$cgi.$prog%>?m=ghw;d=<%=$m{d}%>"><b>ch, gh... w</b></a></td></tr>
<tr><td><a href="<%=$cgi.$prog%>?m=vx;d=<%=$m{d}%>"><b>cx, gx... vx</b></a></td></tr>
<tr><td><a href="<%=$cgi.$prog%>?m=grur;d=<%=$m{d}%>"><b>c`, g`... u`</b></a></td></tr>
<%
	}
%></table>
	
</body>
</html>
<%
	$Response->End;
	exit;
}


# KONTROLAS KIU TTT-LEGILO FARIS LA MENDON
sub kiu_legilo
{	if ($ag =~ m|Mozilla/4| && $ag !~ m|compatible| && $ag !~ m|Opera|)
	{	$netscape_4 = 1;
	}
}


sub redirekti
{	# REDIREKTO - SE LA CELOSISTEMO ESTAS LA SAMA KIEL LA BAZA SISTEMO
	unless ($chiam_trakti eq "jes")
	{
		if ($m{m} eq $baza_sistemo || $m{m} eq "")
		{
			$Response->Redirect($adreso.$loko.$pagho);
			$Response->End;
			exit;
 		}
	}
}

# SSI (INKLUZIVADO DE DOSIEROJ)
sub ssi
{	my $lin = $_[0];
	my $unua = $_[1];
	my $dua = $_[2];

	$dua =~ m!(file|virtual)=["']([\w\./~]+)["']\s*(?:d="([\w/_.]+?)")?!;
	my $dos=$2;
	if ($uzanto ne "" && $dos =~ m!^$uzanto(.*)$!)
	{
		$dos = $loko_de_paghoj.$1;
	}
	else
	{
		$dos = $loko_de_paghoj.$loko.$dos;
	}
	if (-e $Server->MapPath($dos))
	{
		$dos = &legi($dos,0);
		s!$lin!$dos!;
	}
}


# KREAS NOVAN CHAPON
sub nova_chapo
{	s|<!?-?-?\s*[mM][eE][tT][aA](?:\s+[^>\s]+?)*?\s+[Cc][Hh][Aa][Rr][Ss][Ee][Tt]=\s*([^"]+)[^>]*?>\n*||;
	$signokodo_origina = $1;

	if ($m{m} eq "" && $signokodo_origina !~ m![Uu][Tt][Ff]-16!) { $signokodo_nova = uc($signokodo_origina) }
	elsif ($m{m} eq "lat3b") { $signokodo_nova = "" }
	elsif ($m{m} eq "lat3a") { $signokodo_nova = "ISO-8859-3" }
	else { $signokodo_nova = "UTF-8" }

	if ($signokodo_nova ne "")
	{	$chapo = "; charset=$signokodo_nova";
	}
	if
	(
		$signokodo_nova ne ""
	 &&
		$signokodo_nova ne "UTF-8"
	 &&
		m!<\!DOCTYPE\s+html\s+PUBLIC\s+"-//W3C//DTD\s+XHTML!
	 &&
		(! m!\s*<\?xml\s+!)
	)
	{
		$_ = qq(<?xml version="1.0" encoding=""?>\n$_);
	}
	s!\s*(<\?xml\s+[^>]*encoding=["'])[^"']*(["'][^>]*\?>)!$1$signokodo_nova$2!;
}


# ESCEPTAS TEKSTOPARTOJN DE LA TRADUKADO
sub escepti_tekstopartojn
{
	my $protekto = 0;
	while (s|<\!--\s+KOMENCO\s+DE\s+NETRADUKENDA\s+TEKSTOPARTO\s+-->([\s\S]*?)<\!--\s+FINO\s+DE\s+NETRADUKENDA\s+TEKSTOPARTO\s+-->|<@>!KAM-P-$protekto!<@>|)
	{
		push(@protekto,$1);
		++$protekto;
	}
}


# ELEKTAS SISTEMOJN
sub elekti_sistemojn
{	if ($baza_sistemo =~ m!lat3!) { $baza_sistemo = "lat3" }
	@de = @$baza_sistemo;
	$mm = $m{m};
	if ($mm =~ m!lat3!) { $mm = "lat3" }
	@al = @$mm;
}


# ADAPTAS LA ADRESOJN DE LIGOJ EN LA PAGHO
sub adapti_adresojn
{	my $m_parto = "";
	$m_parto = "m=$m{m};" if $m{m} ne "";
	s|(["']?$cgi$prog\?)(d=.+?)(["'])?|$1$m_parto$2$3|g;
	s!([Hh][Rr][Ee][Ff]\s*=\s*["']?)(#)!$1$cgi$prog\?$fasono$pagho$2!g;
	s|([Hh][Rr][Ee][Ff]\s*=\s*["']?)([^:"'>]+?\.[Ss]?[Hh][Tt][Mm][Ll]?)|$1$cgi$prog\?$fasono$2|g;
	s|([Hh][Rr][Ee][Ff]\s*=\s*["']?)([^:"'>]+/)(["'\s>]?)|$1$cgi$prog\?$fasono$2$baza_pagho$3|g;
	s!(<[Ii]?[Ff][Rr][Aa][Mm][Ee])\s+([^>]+?\s*=\s*["']?[^>]+?["']?\s+)?
	  ([Ss][Rr][Cc]\s*=\s*["']?)(?=)!$1\ $2$3$cgi$prog\?$fasono!gx;

	while (s!($cgi$prog\?(?:m=[\w]+?;)?d=(?:[^/"'>]*?/)*?)([^/ "'>]*?/\s*\.\./\s*)!$1!g) {}

	s!(d=)$loko$uzanto!$1!g unless $uzanto eq "";
	unless (m!<[Bb][Aa][Ss][Ee][^>]+[Hh][Rr][Ee][Ff]=!)
	{	s!(<[Hh][Ee][Aa][Dd]([^>]*)?>)\s*!$1\n<base href="$adreso$loko$pagho" />\n!
		||
		s!(</[Tt][Ii][Tt][Ll][Ee]([^>]*)?>)\s*!$1\n<base href="$adreso$loko$pagho">\n!
	}
}


# TRADUKAS UNUE AL UNIKODO
sub traduki_al_unikodo
{	for (my $i = 0; $i < 21; $i++)
	{
		s|\Q$de[$i]\E|$mezo[$i]|g;
	}
}


# PROTEKTAS OKBITAJN SIGNOJN
sub traduki_okbitajn_signojn
{	# CHU LA PAGHO ESTAS UTF-8-A?
	if ($signokodo_origina =~ m![Uu][Tt][Ff]-8! && m![\xa0-\xff]!)
	{	&utf8;
		&lat1;
	}
	# SE NE, CHU LA PAGHO ESTAS LATINO-2-A?
	elsif ($signokodo_origina =~ m![Ii][Ss][Oo]-8859-2!)
	{	&lat2;
		&lat1;
	}
	# SE NE, CHU LA PAGHO ESTAS LATINO-3-A?
	elsif ($signokodo_origina =~ m![Ii][Ss][Oo]-8859-3! && $m{m} !~ m!lat3!)
	{	&lat3;
		&lat1;
	}
	# DO ESTAS SIMPLA LATINO-1-A PAGHO (AU LA VINDOZA SIGNOKODO)
	else
	{	&lat1;
	}
}
sub lat1
{	if ($m{m} =~ m!lat3!)
	{	s|\xC6|&AElig;|g;
		s|\xE6|&aelig;|g;
		s|\xD8|&Oslash;|g;
		s|\xF8|&oslash;|g;
		s|\xA6|&brvbar;|g;
		s|\xB6|&para;|g;
		s|\xAC|&not;|g;
		s|\xBC|&frac14;|g;
		s|\xDE|&THORN;|g;
		s|\xFE|&thorn;|g;
		s|\xDD|&Yacute;|g;
		s|\xFD|&yacute;|g;
	}
	# KOREKTAS VINDOZAJN BITOKOJN INTER 128 KAJ 159
	s|\x80|&#8364;|g;
	s|\x81||g;
	s|\x82|&#8218;|g;
	s|\x83|&#402;|g;
	s|\x84|&#8222;|g;
	s|\x85|&#8230;|g;
	s|\x86|&#8224;|g;
	s|\x87|&#8225;|g;
	s|\x88|&#710;|g;
	s|\x89|&#8240;|g;
	s|\x8A|&#352;|g;
	s|\x8B|&#8249;|g;
	s|\x8C|&#338;|g;
	s|\x8D||g;
	s|\x8E||g;
	s|\x8F||g;
	s|\x90||g;
	s|\x91|&#8216;|g;
	s|\x92|&#8217;|g;
	s|\x93|&#8220;|g;
	s|\x94|&#8221;|g;
	s|\x95|&#8226;|g;
	s|\x96|&#8211;|g;
	s|\x97|&#8212;|g;
	s|\x98|&#8776;|g;
	s|\x99|&#8482;|g;
	s|\x9A|&#353;|g;
	s|\x9B|&#8250;|g;
	s|\x9C|&#339;|g;
	s|\x9D||g;
	s|\x9E||g;
	s|\x9F|&#376;|g;

	# TRADUKAS ALIAJN BITOKOJN EN NUMERAJN KODOJN
	s|([\xa0-\xff])|"&#" . ord($1) . ";"|eg;
}
sub lat2
{	if ($m{m} =~ m!lat3!)
	{	s|\xDD|&Yacute;|g;
		s|\xFD|&yacute;|g;
	}
	s!\xA1!&#260;!g;
	s!\xA2!&#728;!g;
	s!\xA3!&#321;!g;
	s!\xA5!&#317;!g;
	s!\xA6!&#346;!g;
	s!\xA9!&#352;!g;
	s!\xAA!&#350;!g;
	s!\xAB!&#356;!g;
	s!\xAC!&#377;!g;
	s!\xAE!&#381;!g;
	s!\xAF!&#379;!g;
	s!\xB1!&#261;!g;
	s!\xB2!&#731;!g;
	s!\xB3!&#322;!g;
	s!\xB5!&#318;!g;
	s!\xB6!&#347;!g;
	s!\xB7!&#711;!g;
	s!\xB9!&#353;!g;
	s!\xBA!&#351;!g;
	s!\xBB!&#357;!g;
	s!\xBC!&#378;!g;
	s!\xBD!&#733;!g;
	s!\xBE!&#382;!g;
	s!\xBF!&#380;!g;
	s!\xC0!&#340;!g;
	s!\xC3!&#258;!g;
	s!\xC5!&#313;!g;
	s!\xC6!&#262;!g;
	s!\xC8!&#268;!g;
	s!\xCA!&#280;!g;
	s!\xCC!&#282;!g;
	s!\xCF!&#270;!g;
	s!\xD2!&#327;!g;
	s!\xD5!&#336;!g;
	s!\xD8!&#344;!g;
	s!\xD9!&#366;!g;
	s!\xDB!&#368;!g;
	s!\xDE!&#354;!g;
	s!\xE0!&#341;!g;
	s!\xE3!&#259;!g;
	s!\xE5!&#314;!g;
	s!\xE6!&#263;!g;
	s!\xE8!&#269;!g;
	s!\xEA!&#281;!g;
	s!\xEC!&#283;!g;
	s!\xEF!&#271;!g;
	s!\xF0!&#273;!g;
	s!\xF1!&#324;!g;
	s!\xF2!&#328;!g;
	s!\xF5!&#337;!g;
	s!\xF8!&#345;!g;
	s!\xF9!&#367;!g;
	s!\xFB!&#369;!g;
	s!\xFE!&#355;!g;
	s!\xFF!&#729;!g;
}
sub lat3
{	s!\xA1!&#294;!g;
	s!\xA2!&#728;!g;
	s!\xA9!&#304;!g;
	s!\xAA!&#350;!g;
	s!\xAB!&#286;!g;
	s!\xAF!&#379;!g;
	s!\xB1!&#295;!g;
	s!\xB9!&#305;!g;
	s!\xBA!&#351;!g;
	s!\xBB!&#287;!g;
	s!\xBF!&#380;!g;
	s!\xC5!&#266;!g;
	s!\xD5!&#288;!g;
	s!\xE5!&#267;!g;
	s!\xF5!&#289;!g;
	s!\xFF!&#729;!g;
}
sub utf8
{	s!([\xf0-\xf7])([\x80-\xbf])([\x80-\xbf])([\x80-\xbf])!"&#".((ord($1)-0xF0)*2**18+(ord($1)-0x80)*2**12+(ord($3)-0x80)*2**6+(ord($4)-0x80)).";"!eg;
	s!([\xe0-\xef])([\x80-\xbf])([\x80-\xbf])!"&#".((ord($1)-0xE0)*2**12+(ord($2)-0x80)*2**6+(ord($3)-0x80)).";"!eg;
	s!([\xc0-\xdf])([\x80-\xbf])!"&#".((ord($1)-0xC0)*2**6+(ord($2)-0x80)).";"!eg;
}


# TRADUKAS EN LA MENDITAN SISTEMON
sub traduki_al_celsistemo
{	my $j;
	for ($j = 0; $j < 18; $j++)
	{
		if ($j == 6 && $al[6] eq $al[12] && $de[6] eq $de[12]) { $j = 12 }

		if ($j > 5 && $j < 12)
		{
			s|$mezo[$j](?![a-z])|$al[$j]|g || s|$mezo[$j]|$al[$j+6]|g;
		}
		else
		{
			s|$mezo[$j]|$al[$j]|g;
		}
	}

	# ZORGADO PRI KOLIZIOJ INTER LATINO 1 KAJ LATINO 3
	if ($m{m} eq "lat3b")
	{	&latino_3_surogatoj;
	}
	elsif ($m{m} eq "lat3a")
	{	&latino_3_surogatoj
		unless ( ($ag =~ m|MSIE\s[45]| && $ag =~ m|Win|) || $ag =~ m|Mozilla\s5|);
	}
}
sub latino_3_surogatoj
{	s|&AElig;|&#65;&#69;|g;
	s|&aelig;|&#97;&#101;|g;
	s|&Oslash;|&#79;&#47;|g;
	s|&oslash;|&#111;&#47;|g;
	s|&brvbar;|&#124;|g;
	s|&para;|&#167;|g;
	s|&not;|&#45;&#124;|g;
	s|&frac14;|1&#47;4|g;
	s|&THORN;|&#84;&#72;|g;
	s|&thorn;|&#116;&#104;|g;
	s|&Yacute;|&#89;\xb4|g;
	s|&yacute;|&#121;\xb4|g;
}


# FINAJ PRIZORGADOJ
sub adapti_elektilojn
{	# ADAPTAS SIMPLAN ELEKTILON
	my $sistemokomenco = "<\!-- SISTEMO KOMENCO -->";
	my $sistemofino = "<\!-- SISTEMO FINO -->";
	s|$sistemokomenco[\s\S]*?$sistemofino|$sistemoj{$m{m}}|g;

	# ADAPTAS LUKSAN ELEKTILON
	unless ($m{m} eq "")
	{
		s!(<[Oo][Pp][Tt][Ii][Oo][Nn]\s+[Vv][Aa][Ll][Uu][Ee]=["'][^"]*["']) selected(="selected")?\s*(?=>)!$1!;
		s!(<[Oo][Pp][Tt][Ii][Oo][Nn]\s+[Vv][Aa][Ll][Uu][Ee]=["']$m{m}(["']))(?=>)!$1 selected="selected"!;
	}
}

sub remeti_protektitajn_tekstopartojn
{	s!$1!shift(@protekto)!e while m|(<\@>!KAM-P-\d+!<\@>)|;
}

# SE NE EKZISTAS LA MENDITA PAGHO
sub fiasko
{
	unless ($_[0] eq 0)
	{
%><html><head><title>Raporto de la Kameleono</title></head><body>
<h2>La Kameleono raportas:</h2>
<p>"<tt><%=$m{d}%></tt>" ne estas trovebla! :-(</p>
</body></html>
<%
		$Response->End;
		exit;
	}
}

sub aktuala_sistemo
{	if ($m{m} ne "" && $m{m} ne $baza_sistemo)
	{	s|<\!-- AKTUALA SISTEMO -->|m=$m{m};|;
	}
}


sub legi
{	my $legajho;
	undef $/;
	open(LEG,$Server->MapPath($_[0])) || &fiasko($_[1]);
	binmode LEG;
	$legajho = <LEG>;
	close LEG;

	if
	(	$legajho =~ m!^(\xff\xfe)! ||
		$legajho =~ m!^(\xfe\xff)! ||
		$legajho =~ m!^(?:[\s\S][\s\S])*?(<\x00[Tt]\x00[Ii]\x00[Tt]\x00[Ll]\x00[Ee]\x00)! || 
		$legajho =~ m!^(?:[\s\S][\s\S])*?(\x00<\x00[Tt]\x00[Ii]\x00[Tt]\x00[Ll]\x00[Ee])!
	)
	{	$legajho = &utf16($legajho,$1);
	}
	if ($legajho =~ m!\n!)
	{	$legajho =~ s!\r!!g;
	}
	else
	{	$legajho =~ s!\r!\n!g;
	}
	return $legajho;
}


# ZORGAS PRI UNIKODO LAU UTF-16
sub utf16
{	my $teksto = $_[0];
	my $bom = $_[1];
	if ($bom eq "\xff\xfe" || $bom =~ m!<\x00[Tt]\x00[Ii]\x00[Tt]\x00[Ll]\x00[Ee]\x00!)
	{ $bom = 1 }
	else { $bom = 2 }

	$teksto =~ s!^(\xff\xfe)|(\xfe\xff)!!;

	if ($bom == 1) { $teksto =~ s!([\s\S])([\xd8-\xdb])([\s\S])([\xdc-\xdf])!&surogatoj16($2,$1,$4,$3,$bom)!eg }
	else { $teksto =~ s!([\xd8-\xdb])([\s\S])([\xdc-\xdf])([\s\S])!&surogatoj16($1,$2,$3,$4,$bom)!eg }

	if ($bom == 1) { $teksto =~ s!([\s\S])([\s\S])! if ($2 eq "\x00") { $1 } else { "&#" . (ord($1) + ord($2)*256) . ";" } !eg }
	else { $teksto =~ s!([\s\S])([\s\S])! if ($1 eq "\x00") { $2 } else { "&#" . (ord($2) + ord($1)*256) . ";" } !eg }

	return $teksto;
}
sub surogatoj16
{
	my $signo = 0x10000+(ord($_[0])*0x100+ord($_[1])-0xd800)*0x400+ord($_[2])*0x100+ord($_[3])-0xdc00;

	if ($_[4] == 1)
	{
		$signo =~ s!(.)!$1\x00!g;
		return "&\x00#\x00$signo;\x00";
	}
	else
	{
		$signo =~ s!(.)!\x00$1!g;
		return "\x00&\x00#$signo\x00;";
	}
}
%>
