#!/usr/bin/perl

# La Kameleono
# Tio chi estas la CGI-versio de la Kameleono. Ekzistas ankau du ASP-versioj.
# CGI-Kameleono - Versio 5.0 (26 Marto 2001) - Reverkita por funkcii kun "mod_perl" en "Apache"
# Verkita de Bertilo Wennergren

use CGI qw/:cgi/;

# DIFINU CHI TIE LA BAZAJN ELEKTOJN POR LA KAMELEONO
my $adreso = "http://www.servilo.eo/~nomo/";
my $loko_de_paghoj = "../";
my $baza_sistemo = "unik";
my $baza_pagho = "index.html";
my $chiam_trakti = "ne";
my $purismo = "ne";
my $ssi = "ne";
#	FINO DE LA BAZAJ ELEKTOJ POR LA KAMELEONO

# NOMOJ DE LA SISTEMOJ
my %sistemoj =
(	unik  => qq (Esperantaj literoj: <tt>Unikodo</tt>&nbsp;),
	lat3a => qq (Esperantaj literoj: <tt>Latino 3</tt>&nbsp;),
	lat3b => qq (Esperantaj literoj: <tt>Latino 3 sen signokoda indiko</tt>&nbsp;),
	ghu   => qq (Esperantaj literoj: <tt>ch, gh... u</tt>&nbsp;),
	x     => qq (Esperantaj literoj: <tt>cx, gx... ux</tt>&nbsp;),
	cgcu  => qq (Esperantaj literoj: <tt>^c, ^g... ^u</tt>&nbsp;),
	gcuc  => qq (Esperantaj literoj: <tt>c^, g^,... u^</tt>&nbsp;),
	cgtu  => qq (Esperantaj literoj: <tt>^c, ^g... ~u</tt>&nbsp;),
	gcut  => qq (Esperantaj literoj: <tt>c^, g^... u~</tt>&nbsp;),
	ghw   => qq (Esperantaj literoj: <tt>ch, gh... w</tt>&nbsp;),
	vx    => qq (Esperantaj literoj: <tt>cx, gx... vx</tt>&nbsp;),
	grur  => qq (Esperantaj literoj: <tt>c`, u`... u`</tt>&nbsp;)
);

# VARIABLOJ POSTE UZOTAJ
my (@unik,@utf8,@lat3,@ghu,@x,@cgcu,@gcuc,@cgtu,@gcut,@ghw,@vx,@grur,$mm);
my ($metodo, $paghomendo, $koloroj, @mezo, @protekto, @de, @al);
my ($uzanto, $loko, $pagho, $fasono, $prog, $cgi, $tradukescepto);
my ($bazo, $mendita_teksto, $chapo, $signokodo_origina, $signokodo_nova, $stilfolio, $netscape_4);
my $alvokinto = $ENV{HTTP_USER_AGENT};
my $servilnomo = $ENV{'SERVER_NAME'};
my $programetonomo = $ENV{'SCRIPT_NAME'};

@unik = (
	"&#265;", "&#285;", "&#293;", "&#309;", "&#349;", "&#365;", 
	"&#264;", "&#284;", "&#292;", "&#308;", "&#348;", "&#364;", 
	"&#264;", "&#284;", "&#292;", "&#308;", "&#348;", "&#364;", 
	"&#365;", "&#364;", "&#364;");

@mezo = @unik;

@utf8 = (
	"\xc4\x89", "\xc4\x9d", "\xc4\xa5", "\xc4\xb5", "\xc5\x9d", "\xc5\xad", 
	"\xc4\x88", "\xc4\x9c", "\xc4\xa4", "\xc4\xb4", "\xc5\x9c", "\xc5\xac", 
	"\xc4\x88", "\xc4\x9c", "\xc4\xa4", "\xc4\xb4", "\xc5\x9c", "\xc5\xac", 
	"\xc5\xad", "\xc5\xac", "\xc5\xac");

@lat3 = (
	"\xe6", "\xf8", "\xb6", "\xbc", "\xfe", "\xfd", 
	"\xc6", "\xd8", "\xa6", "\xac", "\xde", "\xdd", 
	"\xc6", "\xd8", "\xa6", "\xac", "\xde", "\xdd", 
	"\xfd", "\xdd", "\xdd");

@ghu = (
	"c&#104;", "g&#104;", "h&#104;", "j&#104;", "s&#104;", "&#117;", 
	"C&#72;", "G&#72;", "H&#72;", "J&#72;", "S&#72;", "&#85;", 
	"C&#104;", "G&#104;", "H&#104;", "J&#104;", "S&#104;", "&#85;", 
	"&#119;", "&#87;", "&#87;");

@x = (
	"cx", "gx", "hx", "jx", "sx", "ux", 
	"CX", "GX", "HX", "JX", "SX", "UX", 
	"Cx", "Gx", "Hx", "Jx", "Sx", "Ux", 
	"vx", "VX", "Vx");

@cgcu = (
	"^c", "^g", "^h", "^j", "^s", "^u", 
	"^C", "^G", "^H", "^J", "^S", "^U", 
	"^C", "^G", "^H", "^J", "^S", "^U", 
	"~u", "~U", "~U");

@gcuc = (
	"c^", "g^", "h^", "j^", "s^", "u^", 
	"C^", "G^", "H^", "J^", "S^", "U^", 
	"C^", "G^", "H^", "J^", "S^", "U^", 
	"u~", "U~", "U~");

@cgtu = (
	"^c", "^g", "^h", "^j", "^s", "~u", 
	"^C", "^G", "^H", "^J", "^S", "~U", 
	"^C", "^G", "^H", "^J", "^S", "~U", 
	"^u", "^U", "^U");

@gcut = (
	"c^", "g^", "h^", "j^", "s^", "u~", 
	"C^", "G^", "H^", "J^", "S^", "U~", 
	"C^", "G^", "H^", "J^", "S^", "U~", 
	"u^", "U^", "U^");

@ghw = (
	"c&#104;", "g&#104;", "h&#104;", "j&#104;", "s&#104;", "&#119;", 
	"C&#72;", "G&#72;", "H&#72;", "J&#72;", "S&#72;", "&#87;", 
	"C&#104;", "G&#104;", "H&#104;", "J&#104;", "S&#104;", "&#87;", 
	"&#117;", "&#85;", "&#85;");

@vx = (
	"cx", "gx", "hx", "jx", "sx", "vx", 
	"CX", "GX", "HX", "JX", "SX", "VX", 
	"Cx", "Gx", "Hx", "Jx", "Sx", "Vx", 
	"ux", "UX", "Ux");

@grur = (
	"c`", "g`", "h`", "j`", "s`", "u`", 
	"C`", "G`", "H`", "J`", "S`", "U`", 
	"C`", "G`", "H`", "J`", "S`", "U`", 
	"u`", "U`", "U`");

# TRANSFORMAS LA HTTP-ADRESON EN LOKAN ADRESON
$adreso .= "/" unless $adreso =~ m!/$!;
($uzanto) = $adreso =~ m!http://[^/]+(/.*?)$!;

# KAPTAS LA MENDON
$metodo = param("m");
$paghomendo = param("d");
$koloroj = param("s");

# TROVAS LA DOSIERUJON KAJ LA PAGHON DE LA MENDO
$paghomendo =~ s|\s||g;
($loko,$pagho) = $paghomendo =~ m!^(.*?/)?([^/]*?\.[Ss]?[Hh][Tt][Mm][Ll]?)?$!g;
$loko =~ s|\\||g;
$pagho = $baza_pagho if $pagho eq "";
$loko = "", $pagho = $baza_pagho if $loko =~ m|\.\./|;

# DIFINAS LA NOMON KAJ LOKON DE LA CGI-PROGRAMETO
($prog = "http://$servilnomo$programetonomo") =~ s|^(.*?)([^\\\/]+)$|$2|;
$cgi = $1;

# SENDAS SIMPLAN ELEKTILON
if (defined $koloroj)
{	my ($koloro1, $koloro2, $koloro3);
	my @koloroj = qw(#ffffff #ffff00 #f0e68c #00ff7f #faebd7 #ff0000 #808000 #cd5c5c #d3d3d3 #ffcc99);

	if ($koloroj =~ m!^(\d)(\d)(\d)?$!)
	{	$koloro1 = qq($koloroj[$1]);
		$koloro2 = qq($koloroj[$2]);
	}
	else
	{	$koloro1 = qq($koloroj[8]);
		$koloro2 = qq($koloroj[9]);
	}
	if ($koloroj =~ m!^\d\d(\d)$!)
	{	$koloro3 = qq($koloroj[$1]); }
	else
	{	$koloro3 = "#000000"; }

	my $elektilo;
	($elektilo = <<"	STOP1") =~ s/^\s*//gm;
		<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
		<html xmlns="http://www.w3.org/1999/xhtml">
		<head>
		<title>Elekti sistemon</title>
		<style type="text/css">
		<!--
		body { background-color: $koloro1; }
		h2 { color: $koloro3; background-color: $koloro1; }
		table { background-color: $koloro2; color: #000; }
		-->
		</style>
		</head>
		<body>
		
		<h2>Elektu sistemon!</h2>
		
		<table summary="Elektilo de sistemoj por la Esperantaj literoj" cellpadding="3%" border="2" frame="border" rules="all">
		<tr><td><a href="$cgi$prog?m=unik;d=$paghomendo"><b>Unikodo: &#265;, &#285;... &#365;</b></a></td></tr>
		<tr><td><a href="$cgi$prog?m=lat3a;d=$paghomendo"><b>Latino 3</b></a></td></tr>
		<tr><td><a href="$cgi$prog?m=lat3b;d=$paghomendo"><b>Latino 3 sen signokoda indiko</b></a></td></tr>
		<tr><td><a href="$cgi$prog?m=ghu;d=$paghomendo"><b>H-sistemo: ch, gh... u</b></a></td></tr>
	STOP1

	unless ($purismo eq "jes")
	{	($elektilo .= <<"		STOP2") =~ s/^\s*//gm;
			<tr><td><a href="$cgi$prog?m=x;d=$paghomendo"><b>cx, gx... ux</b></a></td></tr>
			<tr><td><a href="$cgi$prog?m=cgcu;d=$paghomendo"><b>^c, ^g... ^u</b></a></td></tr>
			<tr><td><a href="$cgi$prog?m=gcuc;d=$paghomendo"><b>c^, g^... u^</b></a></td></tr>
			<tr><td><a href="$cgi$prog?m=cgtu;d=$paghomendo"><b>^c, ^g... ~u</b></a></td></tr>
			<tr><td><a href="$cgi$prog?m=gcut;d=$paghomendo"><b>c^, g^... u~</b></a></td></tr>
			<tr><td><a href="$cgi$prog?m=ghw;d=$paghomendo"><b>ch, gh... w</b></a></td></tr>
			<tr><td><a href="$cgi$prog?m=vx;d=$paghomendo"><b>cx, gx... vx</b></a></td></tr>
			<tr><td><a href="$cgi$prog?m=grur;d=$paghomendo"><b>c`, g`... u`</b></a></td></tr>
		STOP2
	}
	($elektilo .= <<"	STOP3") =~ s/^\s*//gm;
		</table>
	
		</body>
		</html>
	STOP3
	print qq(Content-type: text/html; charset=utf-8\n\n);
	print $elektilo;
	exit;
}


# TROVAS LA NOMON DE LA LEGILO
if ($alvokinto =~ m|Mozilla/4| && $alvokinto !~ m|compatible| && $alvokinto !~ m|Opera|)
{ $netscape_4 = 1; }

# POSTAJ MENDOKODOJ ENMETOTAJ EN LA LIGOJN DE LA PAGHO
$metodo = "x" if $metodo eq "gxux";
if ($metodo eq "") { $fasono = "d=$loko"; }
else { $fasono = "m=$metodo;d=$loko"; }

# LEGAS LA MENDITAN PAGHON
($mendita_teksto = $loko_de_paghoj.$loko.$pagho) =~ s|(#.*)$||;
$_ = &legi($mendita_teksto,1,$paghomendo);

# REDIREKTO - SE LA CELOSISTEMO ESTAS LA SAMA KIEL LA BAZA SISTEMO
unless ($chiam_trakti eq "jes")
{	if ($metodo eq $baza_sistemo || $metodo eq "")
	{	print qq(Location: $adreso$loko$pagho\n);
		print qq(URI: $adreso$loko$pagho\n\n);
		exit;
	}
}

# SSI
if ($ssi eq "jes") { while (m!(<\!--\s*#(exec|include)\s+([^>]+)\s*-->)!) { &ssi($1,$2,$3,$uzanto,$loko_de_paghoj,$loko) } }

# FORIGAS XML-INDIKON SE "Opera" AU malnova "Mozilla" au "Macintosh MSIE 4" LEGAS
if ( $alvokinto =~ m|Mozilla/[23]| || $alvokinto =~ m!Opera[/ ][0-3]! || ( $alvokinto =~ m|Mozilla/4| ) && ($alvokinto =~ m|Macintosh| ) )
{ s!(<\?xml\s+[^>]*\?>\s*)!!; }

$tradukescepto = 1 if (m|<!-- NETRADUKENDA PAGHO|) || ($metodo eq "");

# KREAS NOVAN CHAPON
unless (m|<!-- NETRADUKENDA PAGHO|)
{	s|<!?-?-?\s*[mM][eE][tT][aA](?:\s+[^>\s]+?)*?\s+[Cc][Hh][Aa][Rr][Ss][Ee][Tt]=\s*([^"]+)[^>]*?>\n*||;
	$signokodo_origina = $1;

	if ($metodo eq "" && $signokodo_origina !~ m![Uu][Tt][Ff]-16!) { $signokodo_nova = uc($signokodo_origina) }
	elsif ($metodo eq "lat3b") { $signokodo_nova = "" }
	elsif ($metodo eq "lat3a") { $signokodo_nova = "ISO-8859-3" }
	else { $signokodo_nova = "UTF-8" }

	if ($signokodo_nova ne "")
	{ $chapo = "; charset=$signokodo_nova"; }
	else { $chapo = "" }
	if
	(
		$signokodo_nova ne ""
	 &&
		$signokodo_nova ne "UTF-8"
	 &&
		m!<\!DOCTYPE\s+html\s+PUBLIC\s+"-//W3C//DTD\s+XHTML!
	 &&
		(! m!\s*<\?xml\s+!)
	)
	{
		$_ = qq(<?xml version="1.0" encoding=""?>\n$_);
	}
	s!\s*(<\?xml\s+[^>]*encoding\s*=\s*["'])[^"']*(["'][^>]*\?>)!$1$signokodo_nova$2!;
}


# ESCEPTAS TEKSTOPARTOJN DE LA TRADUKADO
my $protekto = 0;
while (s|<!--\s+KOMENCO\s+DE\s+NETRADUKENDA\s+TEKSTOPARTO\s+-->([\s\S]*?)<!--\s+FINO\s+DE\s+NETRADUKENDA\s+TEKSTOPARTO\s+-->|<@>!KAM-P-$protekto!<@>|)
{	push(@protekto,$1);
	++$protekto;
}

# ELEKTAS SISTEMOJN
unless ($tradukescepto)
{	if    ($baza_sistemo =~ m!lat3!) { $baza_sistemo = "lat3"; }
	if    ($baza_sistemo eq "unik") { @de = @unik; }
	elsif ($baza_sistemo eq "lat3") { @de = @lat3; }
	elsif ($baza_sistemo eq "ghu") { @de = @ghu; }
	elsif ($baza_sistemo eq "x") { @de = @x; }
	elsif ($baza_sistemo eq "cgcu") { @de = @cgcu; }
	elsif ($baza_sistemo eq "gcuc") { @de = @gcuc; }
	elsif ($baza_sistemo eq "cgtu") { @de = @cgtu; }
	elsif ($baza_sistemo eq "gcut") { @de = @gcut; }
	elsif ($baza_sistemo eq "ghw") { @de = @ghw; }
	elsif ($baza_sistemo eq "vx") { @de = @vx; }
	elsif ($baza_sistemo eq "grur") { @de = @grur; }

	$mm = $metodo;
	if    ($mm =~ m!lat3!) { $mm = "lat3"; }
	if    ($mm eq "unik") { @al = @unik; }
	elsif ($mm eq "lat3") { @al = @lat3; }
	elsif ($mm eq "ghu") { @al = @ghu; }
	elsif ($mm eq "x") { @al = @x; }
	elsif ($mm eq "cgcu") { @al = @cgcu; }
	elsif ($mm eq "gcuc") { @al = @gcuc; }
	elsif ($mm eq "cgtu") { @al = @cgtu; }
	elsif ($mm eq "gcut") { @al = @gcut; }
	elsif ($mm eq "ghw") { @al = @ghw; }
	elsif ($mm eq "vx") { @al = @vx; }
	elsif ($mm eq "grur") { @al = @grur; }
}

if ($metodo ne "" && $metodo ne $baza_sistemo)
{	s|<!-- AKTUALA SISTEMO -->|m=$metodo;|; }


# ADAPTAS LA ADRESOJN DE LIGOJ EN LA PAGHO


my $m_parto = "";
$m_parto = "m=$metodo;" if $metodo ne "";


s|(["']?$cgi$prog\?)(d=.+?)(["'])?|$1$m_parto$2$3|g;
s!([Hh][Rr][Ee][Ff]\s*=\s*["']?)(#)!$1$cgi$prog\?$fasono$pagho$2!g;
s|([Hh][Rr][Ee][Ff]\s*=\s*["']?)([^:"'>]+?\.[Ss]?[Hh][Tt][Mm][Ll]?)|$1$cgi$prog\?$fasono$2|g;
s|([Hh][Rr][Ee][Ff]\s*=\s*["']?)([^:"'>]+/)(["'\s>]?)|$1$cgi$prog\?$fasono$2$baza_pagho$3|g;
s!(<[Ii]?[Ff][Rr][Aa][Mm][Ee])\s+([^>]+?\s*=\s*["']?[^>]+?["']?\s+)?
  ([Ss][Rr][Cc]\s*=\s*["']?)(?=)!$1\ $2$3$cgi$prog\?$fasono!gx;

while (s!($cgi$prog\?(?:m=[\w]+?;)?d=(?:[^/"'>]*?/)*?)([^/ "'>]*?/\s*\.\./\s*)!$1!g) {}

s!(d=)$loko$uzanto!$1!g unless $uzanto eq "";
unless (m!<[Bb][Aa][Ss][Ee][^>]+[Hh][Rr][Ee][Ff]=!)
{	s!(<[Hh][Ee][Aa][Dd]([^>]*)?>)\s*!$1\n<base href="$adreso$loko$pagho" />\n!
	||
	s!(</[Tt][Ii][Tt][Ll][Ee]([^>]*)?>)\s*!$1\n<base href="$adreso$loko$pagho">\n!
}

unless ($tradukescepto)
{	# TRADUKAS UNUE AL UNIKODO
	unless ($de[0] eq "&#265;")
	{	for (my $i = 0; $i < 21; $i++)
		{ s|\Q$de[$i]\E|$mezo[$i]|g; }
	}

	# PROTEKTAS OKBITAJN SIGNOJN

		# CHU LA PAGHO ESTAS UTF-8-A?
	if ($signokodo_origina =~ m![Uu][Tt][Ff]-8! && m![\xa0-\xff]!)
	{	&utf8;
		&lat1($metodo);
	}
		# SE NE, CHU LA PAGHO ESTAS LATINO-2-A?
	elsif ($signokodo_origina =~ m![Ii][Ss][Oo]-8859-2!)
	{	&lat2($metodo);
		&lat1($metodo);
	}
		# SE NE, CHU LA PAGHO ESTAS LATINO-3-A?
	elsif ($signokodo_origina =~ m![Ii][Ss][Oo]-8859-3! && $metodo !~ m!lat3!)
	{	&lat3;
		&lat1($metodo);
	}
		# DO ESTAS SIMPLA LATINO-1-A PAGHO (AU LA VINDOZA SIGNOKODO)
	else
	{ &lat1($metodo); }

	# TRADUKAS EN LA MENDITAN SISTEMON
	unless ($al[0] eq "&#265;")
	{	my $j;
		for ($j = 0; $j < 18; $j++)
		{	if ($j == 6 && $al[6] eq $al[12] && $de[6] eq $de[12]) { $j = 12 }
	
			if ($j > 5 && $j < 12)
			{ s|$mezo[$j](?![a-z])|$al[$j]|g || s|$mezo[$j]|$al[$j+6]|g; }
			else
			{ s|$mezo[$j]|$al[$j]|g; }
		}
	
		# ZORGADO PRI KOLIZIOJ INTER LATINO 1 KAJ LATINO 3
		if ($metodo eq "lat3b")
		{ &latino_3_surogatoj; }
		elsif ($metodo eq "lat3a")
		{	&latino_3_surogatoj($metodo)
			unless ( ($alvokinto =~ m|MSIE\s[45]| && $alvokinto =~ m|Win|) || $alvokinto =~ m|Mozilla\s5|);
		}
	}
}

# FINAJ PRIZORGADOJ
# ADAPTAS SIMPLAN ELEKTILON
my $sistemokomenco = "<!-- SISTEMO KOMENCO -->";
my $sistemofino = "<!-- SISTEMO FINO -->";
s|$sistemokomenco[\s\S]*?$sistemofino|$sistemoj{$metodo}|g;

# ADAPTAS LUKSAN ELEKTILON
unless ($metodo eq "")
{	s!(<[Oo][Pp][Tt][Ii][Oo][Nn]\s+[Vv][Aa][Ll][Uu][Ee]=["'][^"]*["']) selected(="selected")?\s*(?=>)!$1!;
	s!(<[Oo][Pp][Tt][Ii][Oo][Nn]\s+[Vv][Aa][Ll][Uu][Ee]=["']$metodo(["']))(?=>)!$1 selected="selected"!;
}
s!$1!shift(@protekto)!e while m|(<\@>!KAM-P-\d+!<\@>)|;

# LIVERAS LA PRETAN PAGHON
print qq(Content-type: text/html$chapo\n\n$_);

##############
# SUBRUTINOJ #

sub lat1
{
	my $mm = shift;
	if ($mm =~ m!lat3!)
	{	s|\xC6|&AElig;|g;
		s|\xE6|&aelig;|g;
		s|\xD8|&Oslash;|g;
		s|\xF8|&oslash;|g;
		s|\xA6|&brvbar;|g;
		s|\xB6|&para;|g;
		s|\xAC|&not;|g;
		s|\xBC|&frac14;|g;
		s|\xDE|&THORN;|g;
		s|\xFE|&thorn;|g;
		s|\xDD|&Yacute;|g;
		s|\xFD|&yacute;|g;
	}
	# KOREKTAS VINDOZAJN BITOKOJN INTER 128 KAJ 159
	s|\x80|&#8364;|g;
	s|\x81||g;
	s|\x82|&#8218;|g;
	s|\x83|&#402;|g;
	s|\x84|&#8222;|g;
	s|\x85|&#8230;|g;
	s|\x86|&#8224;|g;
	s|\x87|&#8225;|g;
	s|\x88|&#710;|g;
	s|\x89|&#8240;|g;
	s|\x8A|&#352;|g;
	s|\x8B|&#8249;|g;
	s|\x8C|&#338;|g;
	s|\x8D||g;
	s|\x8E||g;
	s|\x8F||g;
	s|\x90||g;
	s|\x91|&#8216;|g;
	s|\x92|&#8217;|g;
	s|\x93|&#8220;|g;
	s|\x94|&#8221;|g;
	s|\x95|&#8226;|g;
	s|\x96|&#8211;|g;
	s|\x97|&#8212;|g;
	s|\x98|&#8776;|g;
	s|\x99|&#8482;|g;
	s|\x9A|&#353;|g;
	s|\x9B|&#8250;|g;
	s|\x9C|&#339;|g;
	s|\x9D||g;
	s|\x9E||g;
	s|\x9F|&#376;|g;

	# TRADUKAS ALIAJN BITOKOJN EN NUMERAJN KODOJN
	s|([\xa0-\xff])|"&#" . ord($1) . ";"|eg;
}
sub lat2
{	my $mm = shift;
	if ($mm =~ m!lat3!)
	{	s|\xDD|&Yacute;|g;
		s|\xFD|&yacute;|g;
	}
	s!\xA1!&#260;!g;
	s!\xA2!&#728;!g;
	s!\xA3!&#321;!g;
	s!\xA5!&#317;!g;
	s!\xA6!&#346;!g;
	s!\xA9!&#352;!g;
	s!\xAA!&#350;!g;
	s!\xAB!&#356;!g;
	s!\xAC!&#377;!g;
	s!\xAE!&#381;!g;
	s!\xAF!&#379;!g;
	s!\xB1!&#261;!g;
	s!\xB2!&#731;!g;
	s!\xB3!&#322;!g;
	s!\xB5!&#318;!g;
	s!\xB6!&#347;!g;
	s!\xB7!&#711;!g;
	s!\xB9!&#353;!g;
	s!\xBA!&#351;!g;
	s!\xBB!&#357;!g;
	s!\xBC!&#378;!g;
	s!\xBD!&#733;!g;
	s!\xBE!&#382;!g;
	s!\xBF!&#380;!g;
	s!\xC0!&#340;!g;
	s!\xC3!&#258;!g;
	s!\xC5!&#313;!g;
	s!\xC6!&#262;!g;
	s!\xC8!&#268;!g;
	s!\xCA!&#280;!g;
	s!\xCC!&#282;!g;
	s!\xCF!&#270;!g;
	s!\xD2!&#327;!g;
	s!\xD5!&#336;!g;
	s!\xD8!&#344;!g;
	s!\xD9!&#366;!g;
	s!\xDB!&#368;!g;
	s!\xDE!&#354;!g;
	s!\xE0!&#341;!g;
	s!\xE3!&#259;!g;
	s!\xE5!&#314;!g;
	s!\xE6!&#263;!g;
	s!\xE8!&#269;!g;
	s!\xEA!&#281;!g;
	s!\xEC!&#283;!g;
	s!\xEF!&#271;!g;
	s!\xF0!&#273;!g;
	s!\xF1!&#324;!g;
	s!\xF2!&#328;!g;
	s!\xF5!&#337;!g;
	s!\xF8!&#345;!g;
	s!\xF9!&#367;!g;
	s!\xFB!&#369;!g;
	s!\xFE!&#355;!g;
	s!\xFF!&#729;!g;
}
sub lat3
{	s!\xA1!&#294;!g;
	s!\xA2!&#728;!g;
	s!\xA9!&#304;!g;
	s!\xAA!&#350;!g;
	s!\xAB!&#286;!g;
	s!\xAF!&#379;!g;
	s!\xB1!&#295;!g;
	s!\xB9!&#305;!g;
	s!\xBA!&#351;!g;
	s!\xBB!&#287;!g;
	s!\xBF!&#380;!g;
	s!\xC5!&#266;!g;
	s!\xD5!&#288;!g;
	s!\xE5!&#267;!g;
	s!\xF5!&#289;!g;
	s!\xFF!&#729;!g;
}
sub utf8
{	s!([\xf0-\xf7])([\x80-\xbf])([\x80-\xbf])([\x80-\xbf])!"&#".((ord($1)-0xF0)*2**18+(ord($1)-0x80)*2**12+(ord($3)-0x80)*2**6+(ord($4)-0x80)).";"!eg;
	s!([\xe0-\xef])([\x80-\xbf])([\x80-\xbf])!"&#".((ord($1)-0xE0)*2**12+(ord($2)-0x80)*2**6+(ord($3)-0x80)).";"!eg;
	s!([\xc0-\xdf])([\x80-\xbf])!"&#".((ord($1)-0xC0)*2**6+(ord($2)-0x80)).";"!eg;
}


sub latino_3_surogatoj
{	s|&AElig;|&#65;&#69;|g;
	s|&aelig;|&#97;&#101;|g;
	s|&Oslash;|&#79;&#47;|g;
	s|&oslash;|&#111;&#47;|g;
	s|&brvbar;|&#124;|g;
	s|&para;|&#167;|g;
	s|&not;|&#45;&#124;|g;
	s|&frac14;|1&#47;4|g;
	s|&THORN;|&#84;&#72;|g;
	s|&thorn;|&#116;&#104;|g;
	s|&Yacute;|&#89;\xb4|g;
	s|&yacute;|&#121;\xb4|g;
}

# SE NE EKZISTAS LA MENDITA PAGHO
sub fiasko
{	my $ee = shift;
	my $md = shift;
	my $mesagho;
	unless ($ee eq 0)
	{	print qq(Content-type: text/html\n\n);
	 	($mesagho = <<"		STOPM") =~ s/^\s*//gm;
			<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
			    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
			<html xmlns="http://www.w3.org/1999/xhtml">
			<head>
			<title>Raporto de la Kameleono</title>
			</head>
			<body>
			<h1>La Kameleono raportas:</h1>
			<p>
				"<tt>$md</tt>" ne estas trovebla! :-(
			</p>
			</body>
			</html>
		STOPM
		print $mesagho;
		exit;
	}
}

sub legi
{	my $legajho;
	my $dd = shift;
	my $ee = shift;
	my $md = shift;
	undef $/;
	open(LEG,$dd) || &fiasko($ee,$md);
	binmode LEG;
	$legajho = <LEG>;
	close LEG;
	if
	(	$legajho =~ m!^(\xff\xfe)! ||
		$legajho =~ m!^(\xfe\xff)! ||
		$legajho =~ m!^(?:[\s\S][\s\S])*?(<\x00[Tt]\x00[Ii]\x00[Tt]\x00[Ll]\x00[Ee]\x00)! || 
		$legajho =~ m!^(?:[\s\S][\s\S])*?(\x00<\x00[Tt]\x00[Ii]\x00[Tt]\x00[Ll]\x00[Ee])!
	)
	{ $legajho = &utf16($legajho,$1); }
	if ($legajho =~ m!\n!)
	{ $legajho =~ s!\r!!g; }
	else
	{ $legajho =~ s!\r!\n!g; }
	return $legajho;
}

# ZORGAS PRI UNIKODO LAU UTF-16
sub utf16
{	my $teksto = shift;
	my $bom = shift;
	if ($bom eq "\xff\xfe" || $bom =~ m!<\x00[Tt]\x00[Ii]\x00[Tt]\x00[Ll]\x00[Ee]\x00!)
	{ $bom = 1 }
	else { $bom = 2 }

	$teksto =~ s!^(\xff\xfe)|(\xfe\xff)!!;

	if ($bom == 1) { $teksto =~ s!([\s\S])([\xd8-\xdb])([\s\S])([\xdc-\xdf])!&surogatoj16($2,$1,$4,$3,$bom)!eg }
	else { $teksto =~ s!([\xd8-\xdb])([\s\S])([\xdc-\xdf])([\s\S])!&surogatoj16($1,$2,$3,$4,$bom)!eg }

	if ($bom == 1) { $teksto =~ s!([\s\S])([\s\S])! if ($2 eq "\x00") { $1 } else { "&#" . (ord($1) + ord($2)*256) . ";" } !eg }
	else { $teksto =~ s!([\s\S])([\s\S])! if ($1 eq "\x00") { $2 } else { "&#" . (ord($2) + ord($1)*256) . ";" } !eg }

	return $teksto;
}
sub surogatoj16
{	my $unua = shift;
	my $dua = shift;
	my $tria = shift;
	my $kvara = shift;
	my $kvina = shift;

	my $signo = 0x10000+(ord($unua)*0x100+ord($dua)-0xd800)*0x400+ord($tria)*0x100+ord($kvara)-0xdc00;

	if ($kvina == 1)
	{	$signo =~ s!(.)!$1\x00!g;
		return "&\x00#\x00$signo;\x00";
	}
	else
	{	$signo =~ s!(.)!\x00$1!g;
		return "\x00&\x00#$signo\x00;";
	}
}
# SSI (INKLUZIVADO DE DOSIEROJ)
sub ssi
{	my $lin = shift;
	my $unua = shift;
	my $dua = shift;
	my $uzanto = shift;
	my $loko_de_paghoj = shift;
	my $loko = shift;

	if ($unua =~ m!^[Ee][Xx][Ee][Cc]$!)
	{	$dua =~ m![Cc][Gg][Ii]=["'].*?([^/"'?]+)\??([^"'?]*)["']!;
		my $exec = $1; my $argumentoj = $2;

		my $rezulto = "";

		if (-e "$exec") { $rezulto = `perl $exec $argumentoj` }
# PROBLEMOJ PRI EXEC:
# Se vi uzas la Kameleonon che Mikrosofta servilo, la SSI-komando "exec" eble ne
# funkcias. Tio estas tamen riparebla, sed ne tre facile. Necesas anstatauigi la tutan
# chi-antauan linion, 'if (-e "$exec")...', per io simila al la linio kio sekvos chi tie,
# (minus la enkonduka #-signo). Necesas eksplicite indiki la diskajn situojn kaj de
# viaj TTT-paghoj, kaj de Perlo mem, kaj en sufiche tikla maniero. Zorgu! Jen:
#		if (-e "e:/domains/www/nomo/cgi-bin/$exec") { $rezulto = `c:\\perl\\bin\\perl e:\\domains\\www\\nomo\\cgi-bin\\$exec $argumentoj` }

		else {$rezulto = ""}
		s|\Q$lin\E|$rezulto|;
	}
	if ($unua =~ m!^[Ii][Nn][Cc][Ll][Uu][Dd][Ee]$!)
	{	$dua =~ m!(file|virtual)=["']([\w\./~]+)["']\s*(?:d="([\w/_.]+?)")?!;
		my $dos=$2;
		if ($uzanto ne "" && $dos =~ m!^$uzanto(.*)$!)
		{ $dos = $loko_de_paghoj.$1; }
		else { $dos = $loko_de_paghoj.$loko.$dos; }
		if (-e $dos)
		{	$dos = &legi($dos,0);
			s!$lin!$dos!;
		}
	}
}
